-- Mounting 3D model paths and texture paths
mount_vfs_texture_path  (current_mod_path .. "/Textures/Bf-109K-4")
--mount_vfs_texture_path  (current_mod_path.."/Skins/1/ME")
--mount_vfs_model_path    (current_mod_path.."/Cockpit/Resources/Model/Shape")
--mount_vfs_texture_path  (current_mod_path.."/Cockpit/Resources/Model/Textures")

-- Easing possible checksum test
dofile(current_mod_path .. "/Views.lua")



declare_loadout(
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= "BF109K_4_FUEL_TANK",
		attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "PTB.png",
		displayName	= _("Fuel Tank 300 liters"),
		Weight_Empty	= 50.0,
		Weight		= 50.0 + 216,
		Cx_pil		= 0.001313754,
		shape_table_data = 
		{
			{
				file	= "Drop_Tank_300_Liter";
				life	= 1;
				fire	= { 0, 1};
				username	= "BF109K_4_FUEL_TANK";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				DrawArgs	= 
				{
					[1] = {1, 1},
					[2] = {2, 1},
				}, 
				Position	= {0, 0, 0},
				ShapeName	= "Drop_Tank_300_Liter",
			}, 
		}, 
	}
)

--ETC-501
declare_loadout(
{
	category 		= CAT_BOMBS,
	CLSID	 		= "SC_501_SC250",
	attribute		= SC_250.wsTypeOfWeapon,
	Cx_pil			= SC_250.Cx,
	Count 			= 1,
	Picture			= "FAB250.png",
	displayName		= SC_250.user_name,
	Weight			= SC_250.mass,
	Elements  = {
		{
			Position = {0, 0, 0},
			ShapeName = "SC-250",
		}, 
	},
}
)



-- Declaring aircraft
Bf_109K_4 = {

    Name                = 'Bf-109K-4',
    DisplayName         = _('Bf 109 K-4'),

--    HumanCockpit        = true,
--    HumanCockpitPath    = current_mod_path..'/Cockpit/',

    Picture             = "Bf-109K-4.png",
    Rate                = 40, -- RewardPoint in Multiplayer -- TODO evaluate - Made Dragon
    Shape               = "Bf-109K-4",

    shape_table_data    = {
        {
            file        = 'Bf-109K-4';
            life        = 18; -- life bar -- TODO evaluate - Made Dragon
            vis         = 3; -- visibility gain -- TODO evaluate - Made Dragon
            desrt       = 'Bf-109K-4_oblomki'; -- Name of destroyed object file name
            fire        = {300, 2}; -- Fire on the ground after destroyed: 300sec 2m -- TODO evaluate - Made Dragon
            username    = 'Bf-109K-4';
            index       = WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
            positioning = "BYNORMAL";
            drawonmap = true;
        },
        {
            name = "Bf-109K-4_oblomki";
            file = "Bf-109K-4_oblomki";
            fire = {240, 2};
        },},

mapclasskey = "P0091000024", -- ref. MissionEditor/data/NewMap/images/themes/nato/P91000024.png
attribute   = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Battleplanes",}, -- TODO ???
Categories  = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",}, -- TODO ???



    -----------------------------------------------------------------------------------------------



    M_empty         = 2800, -- kg -- TODO evaluate - Made Dragon
    M_nominal       = 3100, -- kg
    M_max           = 3400, -- kg
    M_fuel_max      = 296, -- kg
    H_max           = 13000, -- m -- TODO evaluate - Made Dragon
    average_fuel_consumption = 0.302, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s -- TODO evaluate - Made Dragon
    CAS_min         = 56, -- if this is not OVERALL FLIGHT TIME, but just LOITER TIME, than it should be 10-15 minutes.....CAS capability in minute (for AI) -- TODO evaluate - Made Dragon
    V_opt           = 125,-- Cruise speed (for AI) -- TODO evaluate - Made Dragon
    V_take_off      = 53, -- Take off speed in m/s (for AI) -- TODO evaluate - Made Dragon
    V_land          = 50, -- Land speed in m/s (for AI) -- TODO evaluate - Made Dragon
    V_max_sea_level = 208, -- Max speed at sea level in m/s (for AI) -- TODO evaluate - Made Dragon
    V_max_h         = 230, -- Max speed at max altitude in m/s (for AI) -- TODO evaluate - Made Dragon
    Vy_max          = 22, -- Max climb speed in m/s (for AI) -- TODO evaluate - Made Dragon
    Mach_max        = 0.76, -- Max speed in Mach (for AI) -- TODO evaluate - Made Dragon
    Ny_min          = -4, -- Min G (for AI) -- TODO evaluate - Made Dragon
    Ny_max          = 8.0,  -- Max G (for AI) -- TODO evaluate - Made Dragon
    Ny_max_e        = 8.0,  -- Max G (for AI) -- TODO evaluate - Made Dragon
    AOA_take_off    = 0.157, -- AoA in take off (for AI) -- TODO evaluate - Made Dragon
    bank_angle_max  = 60, -- Max bank angle (for AI) -- TODO evaluate - Made Dragon

    has_afteburner  = false, -- AFB yes/no
    has_speedbrake  = false, -- Air brake yes/no
    has_differential_stabilizer = false, -- Differential stabilizers yes/no

    tand_gear_max   = 0.577, -- tang(a) <- a = steering angle -- TODO evaluate - Made Dragon
    
    nose_gear_pos                            = {-5.219, -0.476, 0.0}, -- Central gear coordinates
    nose_gear_amortizer_direct_stroke        = 0,
    nose_gear_amortizer_reversal_stroke      = -0.114,
    nose_gear_amortizer_normal_weight_stroke = -0.077,
    nose_gear_wheel_diameter                 = 0.350,

    main_gear_pos                            = {0.636, -1.736, 1.118}, -- Main gear coordinates
    main_gear_amortizer_direct_stroke        = 0,
    main_gear_amortizer_reversal_stroke      = -0.176,
    main_gear_amortizer_normal_weight_stroke = -0.079,
    main_gear_wheel_diameter                 = 0.660,
    
    
    tanker_type     = 0, -- Tanker type if the plane is air refuel capable
    wing_area       = 18.3, -- Wing area in m2 -- TODO evaluate - Made Dragon
    wing_span       = 10.5, -- Wing span in metres -- TODO evaluate - Made Dragon
    wing_type       = 0, -- 0 = Fixed wing
                         -- 1 = Variable geometry
                         -- 2 = Fold-able wing
    thrust_sum_max  = 8224, -- Thrust in kg (44kN) -- TODO evaluate - Made Dragon
    thrust_sum_ab   = 8224, -- Thrust in kg (71kN) -- TODO evaluate - Made Dragon
    length          = 12.13, -- Full length in m -- TODO evaluate - Made Dragon
    height          = 4.77, -- Height in m -- TODO evaluate - Made Dragon
    flaps_maneuver  = 0.0, -- Max flaps in take-off and manoeuvre (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
    range           = 1015, -- Max range in km (for AI) -- TODO evaluate - Made Dragon
    RCS             = 2.5, -- Radar Cross Section m2 -- TODO evaluate - Made Dragon
    IR_emission_coeff = 0.1, -- Normal engine -- IR_emission_coeff = 1.0 @ Su-27 without afterburner. It is a reference value. -- TODO evaluate - Made Dragon
    IR_emission_coeff_ab = 0, -- Same with afterburner
    wing_tip_pos    = {-1.1, 0, 4.5}, -- Wing tip coordinates for visual effects -- TODO evaluate - Made Dragon
    nose_gear_wheel_diameter = 0.319, -- in m -- TODO evaluate - Made Dragon
    main_gear_wheel_diameter = 0.683, -- in m -- TODO evaluate - Made Dragon
    brakeshute_name = 0, -- Landing - brake chute visual shape after separation
    is_tanker       = false, -- Tanker yes/no
    air_refuel_receptacle_pos = {0, 0, 0}, -- Refuelling receptacle coordinates

    engines_count = 1, -- Engines count
    engines_nozzles = {
        [1] = {
            pos                 = {1.97, -0.09,-0.56}, -- Nozzle coordinates -- TODO evaluate - Made Dragon
            elevation           = 0, -- AFB cone elevation -- TODO evaluate - Made Dragon
            diameter            = 0 * 0.1, -- AFB cone diameter -- TODO evaluate - Made Dragon
            exhaust_length_ab   = -3.0, -- Length in m -- TODO evaluate - Made Dragon
            exhaust_length_ab_K = 0.3, -- AB animation -- TODO evaluate - Made Dragon
            engine_number       = 1, -- Both to first engine -- TODO evaluate - Made Dragon
        }, -- end of [1]
        [2] = {
            pos                 = {1.97, -0.09, 0.56}, -- Nozzle coordinates -- TODO evaluate - Made Dragon
            elevation           = 0, -- AFB cone elevation -- TODO evaluate - Made Dragon
            diameter            = 0 * 0.1, -- AFB cone diameter -- TODO evaluate - Made Dragon
            exhaust_length_ab   = -3.0, -- Length in m -- TODO evaluate - Made Dragon
            exhaust_length_ab_K = 0.3, -- AB animation -- TODO evaluate - Made Dragon
            engine_number       = 1, -- Both to first engine -- TODO evaluate - Made Dragon
        }, -- end of [1]
    }, -- end of engines_nozzles

    crew_members = {
        [1] = {
            pilot_name          = 56, -- TODO evaluate - Made Dragon
            ejection_seat_name  = 0,
            drop_canopy_name    = "Bf-109K-4_fonar", -- TODO evaluate - Made Dragon
            pos                 = {-1.460000, -0.045000, 0.000000}, -- TODO evaluate - Made Dragon
            canopy_pos          = {-1.203, 0.658, 0}, -- TODO evaluate - Made Dragon
        }, -- end of [1]
    }, -- end of crew_members

    fires_pos = { -- TODO evaluate - Made Dragon
        [1] = {1, 0.5, 0}, -- TODO evaluate - Made Dragon
        [2] = {0.6, -0.25, 0.95}, -- TODO evaluate - Made Dragon
        [3] = {-0.1, -0.3, 0.95}, -- TODO evaluate - Made Dragon
        [4] = {2, -0.5, 0.4}, -- TODO evaluate - Made Dragon
        [5] = {-0.4, -0.25, -2}, -- TODO evaluate - Made Dragon
        [6] = {-1.9, -0.18, 0.4}, -- TODO evaluate - Made Dragon
        [7] = {-1.9, -0.18, -0.4}, -- TODO evaluate - Made Dragon
        [8] = {1.7, -0.1, 0.55}, -- TODO evaluate - Made Dragon
        [9] = {1.7, -0.1, -0.55}, -- TODO evaluate - Made Dragon
        [10] = {-5, 0.5, 0}, -- TODO evaluate - Made Dragon
        [11] = {-5, 0.5, 0}, -- TODO evaluate - Made Dragon
    }, -- end of fires_pos

    -- Countermeasures
    SingleChargeTotal   = 0,
    CMDS_Incrementation = 0,
    ChaffDefault        = 0,
    ChaffChargeSize     = 0,
    FlareDefault        = 0,
    FlareChargeSize     = 0,
    CMDS_Edit           = false,

    -- Sensors
    detection_range_max     = 0,
    radar_can_see_ground    = false, -- This should be examined (what is this exactly?) ???
    CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_BAD, LOOK_AVERAGE, LOOK_AVERAGE),
    Sensors = {
        OPTIC = "Merkury LLTV", -- For night goggles imitation
    },
	
    HumanRadio = {
        frequency = 40.0, --127.5, -- Radio freq
        editable = true,
        minFrequency = 38.0,  --38.4, --100.000,
        maxFrequency = 156.0,  --42.4, --156.000,
        modulation = MODULATION_AM
    },
	
	panelRadio = {
        [1] = {  
            name = _("FuG 16 ZY"),
			range = {min = 38.0, max = 156.0},
            --range = {min = 38.4, max = 42.4},
            channels = {
                [1] = { name = _("Channel 1"), default = 39, modulation = _("AM")},
                [2] = { name = _("Channel 2"), default = 40, modulation = _("AM"), connect = true},
                [3] = { name = _("Channel 3"), default = 41, modulation = _("AM")},
                [4] = { name = _("Channel 4"), default = 42, modulation = _("AM")},
				[5] = { name = _("AFN2 Base Frequency "), default = 38, modulation = _("AM")},
            }
        },
    },

    -- Guns
    Guns = {
        -- LH MG 131
        MG_131({
            muzzle_pos_connector = "Gun_point_1",
            effect_arg_number = 433,
            mixes = {{3, 1, 3, 2}},
            count = 300,
            azimuth_initial = -0.034,
            elevation_initial = -0.298,
            supply_position = {0.284, 0.0, 0.0},
            drop_cartridge = 204,
			ejector_pos_connector = "eject 2",
			ejector_dir 		  = {0,5,0},
            effects = {
                {name = "GunSynchronizer", sectors = 3, reduction_gear = 1.685, engine_rpm_nominal = 1800, dead_angle_degrees = 50},
                {name = "FireEffect", arg = 433},
                {name = "SmokeEffect"}
            }
        }),

        -- RH MG 131
        MG_131({
            muzzle_pos_connector = "Gun_point_2",
            effect_arg_number = 432,
            mixes = {{1, 3, 2, 3}},
            count = 300,
            azimuth_initial = 0.034,
            elevation_initial = -0.298,
            supply_position = {0.284, 0.0, 0.0},
            drop_cartridge = 204,
			ejector_pos_connector = "eject 3",
			ejector_dir 		  = {0,5,0},
            effects = {
                {name = "GunSynchronizer", sectors = 3, reduction_gear = 1.685, engine_rpm_nominal = 1800, dead_angle_degrees = 50},
                {name = "FireEffect", arg = 432},
                {name = "SmokeEffect"}
            }
        }),

        -- Nose MK 108
        MK_108({
            muzzle_pos_connector = "Gun_point_0",
            effect_arg_number = 350,
            mixes = {{1, 3}},
            azimuth_initial = 0,
            elevation_initial = -0.069,
            supply_position = {0.024, 0.0, 0.0},
            drop_cartridge = 0,
			ejector_pos_connector = "eject 1",
			ejector_dir 		  = {0,5,0},
        }),
    },

	Pylons =  {		
		pylon(1, 0, 0, 0, 0, {use_full_connector_position=true,connector = "Pylon1",arg = 308 },
		{
			{ CLSID = "SC_501_SC500", arg_value = 0.25 },
--			{ CLSID = "SC_501_SD500" },
--			{ CLSID = "SC_501_SD250" },
			{ CLSID = "SC_501_SC250", arg_value = 0.25  },
--			{ CLSID = "ER_4_SC50" , arg_value = 0.25 },
			{ CLSID = "BF109K_4_FUEL_TANK",connector = "Pylon1_FuelTank",arg_value = 0.15},
		}),		
    },

    -- Tasks
    Tasks = {
        aircraft_task(CAP),
        aircraft_task(Escort),
		aircraft_task(Intercept),
        aircraft_task(FighterSweep),
        aircraft_task(GroundAttack),
        aircraft_task(CAS),
        aircraft_task(AFAC),
        aircraft_task(RunwayAttack),
        aircraft_task(AntishipStrike),
    },
    DefaultTask = aircraft_task(CAP),

    -- SFM Data
    SFM_Data = {
        aerodynamics = { -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
            Cy0         = 0.1, -- zero AoA lift coefficient
            Mzalfa      = 4.355, -- coefficients for pitch agility
            Mzalfadt    = 0.8, -- coefficients for pitch agility
            kjx         = 2.25,
            kjz         = 0.00125,
            Czbe        = -0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
            cx_gear     = 0.0277, -- coefficient, drag, gear
            cx_flap     = 0.095, -- coefficient, drag, full flaps
            cy_flap     = 0.45, -- coefficient, normal force, lift, flaps
            cx_brk      = 0.06, -- coefficient, drag, breaks
            table_data  = 
			{	--      M		Cx0		 	Cya			B		B4	   	Omxmax	Aldop		Cymax
					{	0.0,	0.0242,	0.0780,		0.0634,		0.0,	0.15,	20.0,		1.58,	},
					{	0.2,	0.0242,	0.0780,		0.0634,		0.0,	1.606,	20.0,		1.58,	},
					{	0.342,	0.0245,	0.0787,		0.061,		0.017,	2.353,	18.0,		1.3,	},
					{	0.5,	0.0263,	0.0770,		0.057,		0.025,	1.145,	16.0,		0.95,	},
					{	0.59,	0.0268,	0.0768,		0.0514,		0.026,	0.761,	15.0,		0.75,	},
					{	0.67,	0.0331,	0.0784,		0.047,		0.021,	0.384,	14.5,		0.62,	},
					{	0.74,	0.0465,	0.0848,		0.08,		0.16,	0.206,	10.0,	  	0.46,	},
					{	0.76,	0.0527,	0.0813,		0.1,		0.25,	0.133,	9.0,  		0.42,	},
					{	0.8,	0.0737,	0.0695,		0.2,		0.36,	0.077,	6.0,		0.38,	},
					{	0.83,	0.1006,	0.0993,		0.34,		2.4,	0.063,	4.5,		0.3,	},
					{	0.9,	0.1470,	0.073,		0.56,		3.0,	0.042,	3.0,		0.2,	},
				}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
        }, -- end of aerodynamics
        engine = {
            Nmg     = 20.5, -- RPM at idle
            MinRUD  = 0, -- Min state of the throttle
            MaxRUD  = 1, -- Max state of the throttle
            MaksRUD = 1, -- Military power state of the throttle
            ForsRUD = 1, -- Afterburner state of the throttle
            typeng  = 2, --PISTON ENGINE
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN				= 4
				E_TURBOSHAFT = 5
			--]]
			
            hMaxEng = 12.5, -- Max altitude for safe engine operation in km
            dcx_eng = 0.015, -- Engine drag coeficient
            cemax   = 0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
            cefor   = 0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
            dpdh_m  = 1800, -- altitude coefficient for max thrust
            dpdh_f  = 1800, -- altitude coefficient for AB thrust

            k_adiab_1           = 0.037923,
            k_adiab_2			= 0.0562,
            MAX_Manifold_P_1	= 180000,		
            MAX_Manifold_P_2	= 180000,		
            MAX_Manifold_P_3	= 180000,		
            k_after_cool		= 0.0,
            Displ				= 35,
            k_Eps				= 6.5,
            Stroke				= 0.165,
            V_pist_0			= 13,
            Nu_0				= 1.2,
            Nu_1				= 0.9,
            Nu_2				= 0.001,
            N_indic_0			= 1052480,
            N_fr_0				= 0.04,
            N_fr_1				= 0.001,
			Init_Mom			= 220,
			D_prop				= 3.5,
			MOI_prop			= 45,
			k_gearbox			= 2.4,
			P_oil				= 495438,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,
			table_data = 
			{
			--   M			Pmax
				{0.0,		16620.0},
				{0.1,		15600.0},
				{0.2,		14340.0},
				{0.3,		13320.0},
				{0.4,		12230.0},
				{0.5,		11300.0},
				{0.6,		10600.0},
				{0.7,		10050.0},
				{0.8,		 9820.0},
				{0.9,		 5902.0},
				{1.9,		 3469.0}
			}
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	},
    -- Damage, index meaning see in Scripts\Aircrafts\_Common\Damage.lua
    Damage = verbose_to_dmg_properties({
        -- Fuselage
        ["FUSELAGE_LEFT_SIDE"]  = {critical_damage = 3, args = {154}},
        ["FUSELAGE_RIGHT_SIDE"] = {critical_damage = 3, args = {153}},
        ["FUSELAGE_BOTTOM"]     = {critical_damage = 3, args = {152}},
        ["COCKPIT"]             = {critical_damage = 2, args = {189}}, -- TODO
        --

        -- Nose
        ["NOSE_BOTTOM"]         = {critical_damage = 3, args = {148}},
        ["NOSE_LEFT_SIDE"]      = {critical_damage = 3, args = {150}},
        ["NOSE_RIGHT_SIDE"]     = {critical_damage = 3, args = {149}},
        ["NOSE_CENTER"]         = {critical_damage = 3, args = {147}},
        ["ROTOR"]               = {critical_damage = 5, args = {146}, deps_cells = {"BLADE_1_IN", "BLADE_2_IN", "BLADE_3_IN"}},
        ["BLADE_1_IN"]      = {critical_damage = 3, args = {429}},
        ["BLADE_2_IN"]      = {critical_damage = 3, args = {430}},
        ["BLADE_3_IN"]      = {critical_damage = 3, args = {431}},
        --

        -- Tail & Sporn
        ["TAIL_BOTTOM"]         = {critical_damage = 3, args = {156}},
        ["TAIL_LEFT_SIDE"]      = {critical_damage = 3, args = {158}},
        ["TAIL_RIGHT_SIDE"]     = {critical_damage = 3, args = {157}},
        --["TAIL"]                = {critical_damage = 3, args = {155}, deps_cells = {"KIL_L", "WHEEL_R"}},
        		
		["TAIL"]				= {critical_damage = 3, args = {81},deps_cells = {"KIL_L","RUDDER","STABILIZER_L_OUT","STABILIZER_R_OUT"}},
		--

        -- Keel & Rudder
        ["KIL_L"]               = {critical_damage = 2, args = {243}, deps_cells = {"FIN_L_TOP","RUDDER", "STABILIZER_L_IN", "STABILIZER_R_IN"}},
        ["FIN_L_TOP"]           = {critical_damage = 2, args = {242}, deps_cells = {"RUDDER"}},
        ["RUDDER"]              = {critical_damage = 2, args = {247}},
        --

        -- Stabilizers & Elevators
        ["STABILIZER_L_IN"]     = {critical_damage = 2, args = {236}, deps_cells = {"STABILIZER_L_OUT"}},
        ["STABILIZER_L_OUT"]    = {critical_damage = 2, args = {235}, deps_cells = {"ELEVATOR_L_IN"}},
        ["ELEVATOR_L_IN"]       = {critical_damage = 2, args = {239}},
        ["STABILIZER_R_IN"]     = {critical_damage = 2, args = {234}, deps_cells = {"STABILIZER_R_OUT"}},
        ["STABILIZER_R_OUT"]    = {critical_damage = 2, args = {233}, deps_cells = {"ELEVATOR_R_IN"}},
        ["ELEVATOR_R_IN"]       = {critical_damage = 2, args = {237}},
        --

        -- Left Wing
        ["WING_L_IN"]           = {critical_damage = 7, args = {225}, deps_cells = {"WING_L_CENTER", "FLAP_L_IN", "PYLONL", "FLAP_L_OUT", "STOIKA_L"}},
        ["WING_L_CENTER"]       = {critical_damage = 7, args = {224}, deps_cells = {"WING_L_OUT"}},
        ["WING_L_OUT"]          = {critical_damage = 6, args = {223}, deps_cells = {"ELERON_L"}},
        ["ELERON_L"]            = {critical_damage = 2, args = {226}},
        ["FLAP_L_IN"]           = {critical_damage = 2, args = {227}},
        ["PYLONL"]              = {critical_damage = 2, args = {228}},
        ["FLAP_L_OUT"]          = {critical_damage = 2, args = {229}},
        --

        -- Right Wing
        ["WING_R_IN"]           = {critical_damage = 7, args = {215}, deps_cells = {"WING_R_CENTER", "FLAP_R_IN", "PYLONR", "FLAP_R_OUT", "STOIKA_R"}},
        ["WING_R_CENTER"]       = {critical_damage = 7, args = {214}, deps_cells = {"WING_R_OUT"}},
        ["WING_R_OUT"]          = {critical_damage = 6, args = {213}, deps_cells = {"ELERON_R"}},
        ["ELERON_R"]            = {critical_damage = 2, args = {216}},
        ["FLAP_R_IN"]           = {critical_damage = 2, args = {217}},
        ["PYLONR"]              = {critical_damage = 2, args = {218}},
        ["FLAP_R_OUT"]          = {critical_damage = 2, args = {219}},
        --

        -- Undercarriage
        ["WHEEL_R"]             = {critical_damage = 2, args = {136}},
        ["STOIKA_L"]            = {critical_damage = 3, args = {134}},
        ["STOIKA_R"]            = {critical_damage = 3, args = {135}},
        --
    }),



    DamageParts = {
        [1] = "Bf-109K-4_oblomok_wing_L", -- wing R
        [2] = "Bf-109K-4_oblomok_wing_R", -- wing L
        [3] = "FW-190D9-part-nose", -- nose
        [4] = "Bf-109K-4_oblomok_tail", -- tail
    },



    AddPropAircraft = {
        { id = 'MW50TankContents', control = 'comboList', label = _('MW / Fuel Tank Contents'), defValue = 1,
            values = {
                { id = 0, dispName = _("Empty")},
                { id = 1, dispName = _("MW50 Mix")},
                { id = 2, dispName = _("B-4 Gasoline")}
            },},
    },



    Failures = {
        
		{ id = 'CTRL_AILERON_ROD_DESTROYED',	  	  	label = _('Aileron control failure'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_AILERON_ROD_MAJOR_DAMAGE',	  	  	label = _('Aileron control crippled'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_AILERON_ROD_MINOR_DAMAGE',	  	  	label = _('Aileron control damaged'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_ELEVATOR_ROD_DESTROYED',	  	  	label = _('Elevator control failure'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_ELEVATOR_ROD_MAJOR_DAMAGE',	  	label = _('Elevator control crippled'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_ELEVATOR_ROD_MINOR_DAMAGE',	  	label = _('Elevator control damaged'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_ELEVATOR_TRIM_FAILURE',	  	  	label = _('Trim drive failure'),								enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_RUDDER_ROD_DESTROYED',	  	  	  	label = _('Rudder control failure'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_RUDDER_ROD_MAJOR_DAMAGE',	  	  	label = _('Rudder control crippled'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_RUDDER_ROD_MINOR_DAMAGE',	  	  	label = _('Rudder control damaged'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'CTRL_LANDING_FLAPS_MECHANICAL_FAILURE',	label = _('Landing flaps chain drive failure'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'ELEC_BATTERY_OVERHEAT',	  	  			label = _('Battery overheated'),								enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_GENERATOR_FAILURE',	  			label = _('Generator failure'),									enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_FUEL_PUMP_P1_FAILURE',	  			label = _('Booster pump P1 failure'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_FUEL_PUMP_P1_COIL_FAILURE',		label = _('Booster pump P1 electrical malfunction'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_FUEL_PUMP_P2_FAILURE',				label = _('Booster pump P2 failure'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_FUEL_PUMP_P2_COIL_FAILURE',		label = _('Booster pump P2 electrical malfunction'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_DASHBOARD_HARNESS_CUT',			label = _('Instrument panel harness severed'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_MASTER_COMPASS_HARNESS_CUT',		label = _('Master compass harness severed'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_UC_LAMP_LHD_BULB_FAILURE',			label = _('LH undercarriage indicator light bulb broken'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_UC_LAMP_RHD_BULB_FAILURE',			label = _('RH undercarriage indicator light bulb broken'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_UC_LAMP_CU_BULB_FAILURE',			label = _('Central undercarriage indicator light bulb broken'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_UMFORMER_FAILURE',					label = _('Artificial horizon umformer failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_PITOT_HEAT_WIRING',				label = _('Pitot heating wire broken'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_PITOT_HEAT_ELEMENT',				label = _('Pitot heating element burned out'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ELEC_RETICLE_BULB_FAILURE',				label = _('Reticle bulb broken'),								enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },

		{ id = 'FUEL_MAIN_FUEL_PUMP_FAILURE',	  	  	label = _('Motor fuel pump failure'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_MAIN_FUEL_PUMP_DEGRADED',	  	  	label = _('Motor fuel pump crippled'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_FUEL_PUMP_P1_DEGRADED',	  	  	label = _('Booster pump P1 mechanical malfunction'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_FUEL_PUMP_P2_DEGRADED',	  	  	label = _('Booster pump P2 mechanical malfunction'),			enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_DROPTANK_LINE_SEVERED',	  	  	label = _('Drop tank suction hose severed'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_MW50_TANK_DRAIN_VALVE_SEVERED',	label = _('MW 50 (KGM1) drain valve open'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_CRFUEL_MAIN_TANK_MINOR_LEAKYSTAL',	label = _('Fuel tank minor leak'),								enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'FUEL_MAIN_TANK_MAJOR_LEAK',	  	  		label = _('Fuel tank leak'),									enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		 
		{ id = 'ENG0_JAMMED',	  	  					label = _('Engine destroyed'),									enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_MAGNETO0',	  	  					label = _('Magneto M1 failure'),								enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_MAGNETO1',	  	  					label = _('Magneto M2 failure'),								enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_GOVERNOR_MALFUNCTION',	  	  		label = _('Propeller governor malfunction'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_GOVERNOR_FAILURE',	  	  			label = _('Propeller governor failure'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_GOVERNOR_REGULATOR_MALFUNCTION',	label = _('Propeller governor regulator failure'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_STARTER_CLUTCH_FAILURE',	  	  	label = _('Starter clutch failure'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_CARBURETTOR_OIL_FEED_CLOGGED',	  	label = _('Injector pressure oil line clogged'),				enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'ENG0_WASTEGATE_OIL_FEED_CLOGGED',	  	label = _('Supercharger limiter pressure oil line clogged'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
	
		{ id = 'VHF_CRYSTAL',	  	  					label = _('Radio. Crystal or tube failure'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_SHORTED_CTL_BOX',	  	  			label = _('Radio. Shorted control box'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_VT_BURNED_OUT',	  	  				label = _('Radio. Receiver burned out'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'VHF_SQUELCH_RELAY',	  	  				label = _('Radio. Squelch relay not working'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'AFN2_DAMAGE',	  	  					label = _('Radio. AFN2 not working'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'HORIZON_BAR_NOT_SETTLE',	  	  		label = _('Artificial Horizon'),								enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_NO_TORQUE',	  					label = _('Remote Compass. No torque'),							enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_ERRATIC_OPERATION',	  			label = _('Remote Compass. Erratic operation'),					enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_POINTER_PULLS',	  				label = _('Remote Compass. Pointer pulls'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'COMPASS_ERRATIC_INDIACATON',			label = _('Remote Compass. Loose pointer'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		{ id = 'INST_VARIOMETR_DEPRESSURIZATION',		label = _('Variometer depressurization'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'INST_SPEEDOMETER_DEPRESSURIZATION',		label = _('Speedometer depressurization'),						enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		{ id = 'INST_PITOT_DAMAGE',						label = _('Pitot damaged'),										enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		
		
    },

	lights_data = {	typename = "collection", lights = {
    [1] = {typename = "collection",lights = {}},
	[2] = {typename = "collection",
			lights = {-- Landing light
					  {typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_02",
					   argument = 209,
					   dir_correction = {elevation = math.rad(-1)}
					  },
					  {-- Landing/Taxi light
					   typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_01",
					   argument = 208,
					   dir_correction = {elevation = math.rad(3)}
					  }
					 }
			},
    [3]	= {typename = "collection",
			lights = {-- Left Position Light (red)
					  {typename = "omnilight",
					   connector = "BANO_1",
					   color = {0.99, 0.11, 0.3},
					   pos_correction  = {0, 0, -0.2},
					   argument  = 190
					  },
					  -- Right Position Light (green)
					  {typename = "omnilight",
					   connector = "BANO_2",
					   color = {0, 0.894, 0.6},
					   pos_correction = {0, 0, 0.2},
					   argument  = 191
					  },
                      -- Tail Position Light (white)
					  {typename = "omnilight",
					   connector = "BANO_3",
					   color = {0.92, 0.92, 0.92},
					   pos_correction = {0, 0, 0.2},
					   argument  = 192
					  }}
			},
    [4] = {typename = "collection",lights = {}},
	[5]	= {typename = "collection",lights = {}},
	}},
	
	ViewSettings = ViewSettings,
	SnapViews    = SnapViews,
	
	
	Countries = {"Germany"},
}

-- Finalize
add_aircraft(Bf_109K_4)
